/** @file   weapon.cpp
 * @brief   Implementation of Weapon - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "weapon.h"
#include "soundsamples.h"
#include "settings.h"


namespace WeWantWar {


std::vector<Weapon::Specs> Weapon::weaponlist;
std::vector<int> Weapon::maxPlayerAmmo;
std::vector<int> Weapon::ammoPacks;

const eng2d::Vec2D Weapon::GRENADE_INITIAL_SPEED(0, -8);
int Weapon::GRENADE_FRAGMENTS = 32;
int Weapon::MAX_GRENADES = 16;
int Weapon::GRENADE_PACK_SIZE = 8;


/** Initializes the weapons
 */
void Weapon::init()
{
  Specs s;
  /* TODO (#1#): Read the bullet trail effect information. */
  
  // Init crowbar
  s.id = W_CROWBAR;
  s.reload = atoi( Settings::getWProp( s.id, "reload:").c_str() );
  s.damage = atoi( Settings::getWProp( s.id, "damage:").c_str() );
  s.speed = -(atof( Settings::getWProp(s.id, "speed:").c_str() ));
  s.range = atof( Settings::getWProp(s.id, "range:").c_str() );
  s.radius = atof( Settings::getWProp( s.id, "radius:").c_str() );
  s.deviation = atoi( Settings::getWProp(s.id, "deviation:").c_str() );
  s.hitSound = atoi( Settings::getWProp(s.id, "hit_sound:").c_str() );
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( 5000000 );
  ammoPacks.push_back( 5000000 );
  
  
  // Init rifle
  s.id = W_RIFLE;
  s.reload = atoi( Settings::getWProp( s.id, "reload:").c_str() );
  s.damage = atoi( Settings::getWProp( s.id, "damage:").c_str() );
  s.speed = -(atof( Settings::getWProp(s.id, "speed:").c_str() ));
  s.range = atof( Settings::getWProp(s.id, "range:").c_str() );
  s.radius = atof( Settings::getWProp( s.id, "radius:").c_str() );
  s.deviation = atoi( Settings::getWProp(s.id, "deviation:").c_str() );
  s.hitSound = atoi( Settings::getWProp(s.id, "hit_sound:").c_str() );
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()));
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()));
  
  // Init shotgun
  s.id = W_SHOTGUN;
  s.reload = atoi( Settings::getWProp( s.id, "reload:").c_str() );
  s.damage = atoi( Settings::getWProp( s.id, "damage:").c_str() );
  s.speed = -(atof( Settings::getWProp(s.id, "speed:").c_str() ));
  s.range = atof( Settings::getWProp(s.id, "range:").c_str() );
  s.radius = atof( Settings::getWProp( s.id, "radius:").c_str() );
  s.deviation = atoi( Settings::getWProp(s.id, "deviation:").c_str() );
  s.hitSound = atoi( Settings::getWProp(s.id, "hit_sound:").c_str() );
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()));
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()));
  
  // init flamethrower
  s.id = W_FLAMETHROWER;
  s.reload = atoi( Settings::getWProp( s.id, "reload:").c_str() );
  s.damage = atoi( Settings::getWProp( s.id, "damage:").c_str() );
  s.speed = -(atof( Settings::getWProp(s.id, "speed:").c_str() ));
  s.range = atof( Settings::getWProp(s.id, "range:").c_str() );
  s.radius = atof( Settings::getWProp( s.id, "radius:").c_str() );
  s.deviation = atoi( Settings::getWProp(s.id, "deviation:").c_str() );
  s.hitSound = atoi( Settings::getWProp(s.id, "hit_sound:").c_str() );
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()));
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()));
  
  // init alien fireball
  s.id = W_ALIENFIREBALL;
  s.reload = atoi( Settings::getWProp( s.id, "reload:").c_str() );
  s.damage = atoi( Settings::getWProp( s.id, "damage:").c_str() );
  s.speed = -(atof( Settings::getWProp(s.id, "speed:").c_str() ));
  s.range = atof( Settings::getWProp(s.id, "range:").c_str() );
  s.radius = atof( Settings::getWProp( s.id, "radius:").c_str() );
  s.deviation = atoi( Settings::getWProp(s.id, "deviation:").c_str() );
  s.hitSound = atoi( Settings::getWProp(s.id, "hit_sound:").c_str() );
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()));
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()));
  
  // init minigun
  s.id = W_MINIGUN;
  s.reload = atoi( Settings::getWProp( s.id, "reload:").c_str() );
  s.damage = atoi( Settings::getWProp( s.id, "damage:").c_str() );
  s.speed = -(atof( Settings::getWProp(s.id, "speed:").c_str() ));
  s.range = atof( Settings::getWProp(s.id, "range:").c_str() );
  s.radius = atof( Settings::getWProp( s.id, "radius:").c_str() );
  s.deviation = atoi( Settings::getWProp(s.id, "deviation:").c_str() );
  s.hitSound = atoi( Settings::getWProp(s.id, "hit_sound:").c_str() );
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()));
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()));
  
  
  // init uzis
  s.id = W_UZI;
  s.reload = Settings::intWProp( s.id, "reload:");
  s.damage = Settings::intWProp( s.id, "damage:");
  s.speed = - Settings::floatWProp(s.id, "speed:");
  s.range = Settings::floatWProp(s.id, "range:");
  s.radius = Settings::floatWProp( s.id, "radius:");
  s.deviation = Settings::intWProp(s.id, "deviation:");
  s.hitSound = Settings::intWProp(s.id, "hit_sound:");
  s.useTrails = Settings::intWProp(s.id, "trail_fx:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()));
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()));
  
  // Init no-weapon
  s.id = W_NOWEAPON;
  s.reload = 1;
  s.damage = 0;
  s.speed = 0;
  s.range = 0;
  s.radius = 0;
  s.deviation = 0;
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( 0 );
  ammoPacks.push_back( 0 );
  
  // Init grenades
  s.id = W_GRENADE;
  s.reload = Settings::intWProp(s.id, "lifetime:");
  s.damage = Settings::intWProp(s.id, "damage:");
  s.speed = - Settings::floatWProp(s.id, "speed:");
  s.range = Settings::floatWProp(s.id, "range:");
  s.radius = Settings::floatWProp(s.id, "radius:" );
  s.hitSound = Settings::intWProp(s.id, "hit_sound:" );
  s.bounce = Settings::intWProp(s.id, "bounce:");
  s.deviation = Settings::intWProp(s.id, "fragments:" );
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( 0 );
  ammoPacks.push_back( 0 );
  
  // Init tank bullet
  s.id = W_TANKBULLET;
  s.reload = Settings::intWProp(s.id, "reload:");
  s.damage = Settings::intWProp(s.id, "damage:");
  s.speed = - Settings::floatWProp(s.id, "speed:");
  s.range = Settings::floatWProp(s.id, "range:");
  s.radius = Settings::floatWProp(s.id, "radius:" );
  s.hitSound = Settings::intWProp(s.id, "hit_sound:" );
  s.bounce = Settings::intWProp(s.id, "bounce:");
  s.deviation = Settings::intWProp(s.id, "deviation:" );
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( 0 );
  ammoPacks.push_back( 0 );
  
  // Init sentry fireball
  s.id = W_SENTRYFIREBALL;
  s.reload = Settings::intWProp(s.id, "reload:");
  s.damage = Settings::intWProp(s.id, "damage:");
  s.speed = - Settings::floatWProp(s.id, "speed:");
  s.range = Settings::floatWProp(s.id, "range:");
  s.radius = Settings::floatWProp(s.id, "radius:" );
  s.hitSound = Settings::intWProp(s.id, "hit_sound:" );
  s.bounce = Settings::intWProp(s.id, "bounce:");
  s.deviation = Settings::intWProp(s.id, "deviation:" );
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( 0 );
  ammoPacks.push_back( 0 );
  
  // Init Sniper rifle
  s.id = W_SNIPERRIFLE;
  s.reload = Settings::intWProp(s.id, "reload:");
  s.damage = Settings::intWProp(s.id, "damage:");
  s.speed = - Settings::floatWProp(s.id, "speed:");
  s.range = Settings::floatWProp(s.id, "range:");
  s.radius = Settings::floatWProp(s.id, "radius:");
  s.hitSound = Settings::intWProp(s.id, "hit_sound:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  s.deviation = Settings::intWProp(s.id, "deviation:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()) );
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()) );
  
  // Init Rocket Launcher
  s.id = W_ROCKETLAUNCHER;
  s.reload = Settings::intWProp(s.id, "reload:");
  s.damage = Settings::intWProp(s.id, "damage:");
  s.speed = - Settings::floatWProp(s.id, "speed:");
  s.range = Settings::floatWProp(s.id, "range:");
  s.radius = Settings::floatWProp(s.id, "radius:");
  s.hitSound = Settings::intWProp(s.id, "hit_sound:");
  s.bounce = Settings::intWProp(s.id, "bounce:");
  s.deviation = Settings::intWProp(s.id, "deviation:");
  weaponlist.push_back( s );
  maxPlayerAmmo.push_back( atoi(Settings::getWProp(s.id, "max_ammo:").c_str()) );
  ammoPacks.push_back( atoi(Settings::getWProp(s.id, "ammopack:").c_str()) );
}



/** Cleansup the weapons
 */
void Weapon::cleanup()
{
}



/** Returns the specs of the requested weapon
 */
Weapon::Specs& Weapon::getWeaponSpecs(int w)
{
  return weaponlist.at(w);
}



/** Returns the maximum ammo the player can carry.
 */
int Weapon::getMaxAmmo(int w)
{
  return maxPlayerAmmo.at(w);
}



/** Returns the number of ammos the ammopack has
 */
int Weapon::getAmmoPack(int w)
{
  return ammoPacks.at(w);
}




/** Constructs new Weapon
 */
Weapon::Weapon( WeaponID id ) :
  m_weaponID( id )
{
}



/** A copy constructor.
 */
Weapon::Weapon( const Weapon& rW ) :
  m_weaponID( rW.m_weaponID )
{
}



/** Destructor.
 */
Weapon::~Weapon()
{
}



/** Assignment operator
 */
Weapon& Weapon::operator = ( const Weapon& rW )
{
  if ( this != &rW ) {
    m_weaponID = rW.m_weaponID;
  }
  return *this;
}



/** Returns the specs of this weapon.
 */
Weapon::Specs& Weapon::getSpecs() const
{
  return weaponlist.at (m_weaponID );
}



/** Returns the id-code of this weapon.
 */
Weapon::WeaponID Weapon::id() const
{
  return m_weaponID;
}



/** Returns the reloading delay.
 */
int Weapon::reload() const
{
  return weaponlist.at( m_weaponID).reload;
}



/** Returns the damagepoints.
 */
int Weapon::damage() const
{
  return weaponlist.at( m_weaponID ).damage;
}



/** Returns the velocity of the bullets.
 */
float Weapon::velocity() const
{
  return weaponlist.at( m_weaponID ).speed;
}



/** Returns the maximum range.
 */
float Weapon::range() const
{
  return weaponlist.at( m_weaponID ).range;
}



/** Returns the radius of the bullets
 */
float Weapon::radius() const
{
  return weaponlist.at( m_weaponID ).radius;
}



/** Returns the deviation angle
 */
int Weapon::deviation() const
{
  return weaponlist.at( m_weaponID ).deviation;
}



/** Returns the hit sound
 */
bool Weapon::hitSound() const
{
  return static_cast<bool>( weaponlist.at(m_weaponID).hitSound );
}



/** Tells if bullets of this weapon should leave trails
 */
bool Weapon::bulletTrails() const
{
  return static_cast<bool>( weaponlist.at(m_weaponID).useTrails );
}



/** Tells if the bullets of this weapon should bounce from the walls
 */
bool Weapon::bouncingBullets() const
{
  return static_cast<bool>( weaponlist.at(m_weaponID).bounce );
}



/** Returns the sound id of this weapon.
 */
int Weapon::getSoundID() const
{
  switch ( m_weaponID ) {
    case ( W_CROWBAR ): {
      return SMP_SLASH;
    }
    case ( W_RIFLE ): {
      return SMP_WEAPON1;
    }
    case ( W_SHOTGUN ): {
      return SMP_WEAPON2;
    }
    case ( W_FLAMETHROWER ): {
      return SMP_WEAPON3;
    }
    case ( W_MINIGUN ): {
      return SMP_WEAPON4;
    }
    case ( W_UZI ): {
      return SMP_WEAPON5;
    }
    case ( W_SNIPERRIFLE ): {
      return SMP_WEAPON6;
    }
    case ( W_ROCKETLAUNCHER ): {
      return SMP_WEAPON7;
    }
  }
  return 0;
}



} // end of namespace
